Scriptname Neisa_OutfitChange extends ReferenceAlias  

import utility
GlobalVariable Property NCOF  Auto  

Event OnDeath(Actor akKiller)
	ClearBuffer()
   	self.clear()
endEvent

Form Property WeaponSlot01 auto hidden
Form Property WeaponSlot02 auto hidden
Form Property WeaponSlot03 auto hidden

Form Property ArmorSlot01 auto hidden
Form Property ArmorSlot02 auto hidden
Form Property ArmorSlot03 auto hidden
Form Property ArmorSlot04 auto hidden
Form Property ArmorSlot05 auto hidden
Form Property ArmorSlot06 auto hidden
Form Property ArmorSlot07 auto hidden
Form Property ArmorSlot08 auto hidden
Form Property ArmorSlot09 auto hidden
Form Property ArmorSlot10 auto hidden

Form Property EmptySlot auto hidden

Bool Property Lock = false  auto hidden

EVENT OnCellLoad()
	wait(0.1)
	EquipCurrentArmor()
	EquipCurrentWeapon()

EndEVENT

EVENT OnLoad()
	wait(0.1)
	EquipCurrentArmor()
	EquipCurrentWeapon()
EndEVENT

EVENT OnEnable()
	wait(0.1)
	EquipCurrentArmor()
	EquipCurrentWeapon()
endEVENT

Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
	if lock == true && NCOF.GetValueInt() == 1
		EquipCurrentArmor()
		EquipCurrentWeapon()
		return
	endif
	if (akBaseItem as Armor) && NCOF.GetValueInt() == 1
		AddToArmorSlot(akBaseItem)
		self.GetActorRef().EquipItem(akBaseItem)
	elseif (akBaseItem as Weapon) && NCOF.GetValueInt() == 1
		AddToWeaponSlot(akBaseItem)
		self.GetActorRef().EquipItem(akBaseItem)
	Endif
endEvent


Event OnObjectUnequipped(Form akBaseObject, ObjectReference akReference)
	if lock == true && NCOF.GetValueInt() == 1
		EquipCurrentArmor()
		EquipCurrentWeapon()	
		return
	endif
	if (akBaseObject as Armor) && NCOF.GetValueInt() == 1
		RemoveFromArmorSlot(akBaseObject)
	elseif  (akBaseObject as Weapon) && NCOF.GetValueInt() == 1
		RemoveFromWeaponSlot(akBaseObject)
	endif
endEvent

Function ChangeState()
	if Lock == true
		lock = false
		debug.notification("Gears are unlocked.")
	Else
		lock = true
		debug.notification("Gears are locked.")
	Endif
EndFunction

Function ClearBuffer()
	lock = false
	ArmorSlot01 = EmptySlot
	ArmorSlot02 = EmptySlot
	ArmorSlot03 = EmptySlot
	ArmorSlot04 = EmptySlot
	ArmorSlot05 = EmptySlot
	ArmorSlot06 = EmptySlot
	ArmorSlot07 = EmptySlot
	ArmorSlot08 = EmptySlot
	ArmorSlot09 = EmptySlot
	ArmorSlot10 = EmptySlot
	WeaponSlot01 = EmptySlot
	WeaponSlot02 = EmptySlot
	WeaponSlot03 = EmptySlot
EndFunction

Function EquipCurrentArmor()
	if self.GetActorRef() == None
		Return
	Endif

	if (ArmorSlot01 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot01)
	endif
	if (ArmorSlot02 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot02)
	endif
	if (ArmorSlot03 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot03)
	endif
	if (ArmorSlot04 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot04)
	endif
	if (ArmorSlot05 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot05)
	endif
	if (ArmorSlot06 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot06)
	endif
	if (ArmorSlot07 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot07)
	endif
	if (ArmorSlot08 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot08)
	endif
	if (ArmorSlot09 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot09)
	endif
	if (ArmorSlot10 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(ArmorSlot10)
	endif
endFunction

Function EquipCurrentWeapon()
	if self.GetActorRef() == None
		Return
	Endif

	if (WeaponSlot01 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(WeaponSlot01)
	endif
	if (WeaponSlot02 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(WeaponSlot02)
	endif
	if (WeaponSlot03 != EmptySlot) && NCOF.GetValueInt() == 1
		self.GetActorRef().EquipItem(WeaponSlot03)
	endif
endFunction


Function AddToArmorSlot(Form akBaseItem)
	
	bool FoundEmptySlot = FALSE
	
	if (ArmorSlot01 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot01 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot02 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot02 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot03 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot03 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot04 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot04 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot05 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot05 = akBaseItem
		FoundEmptySlot = TRUE
	endif

	if (ArmorSlot06 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot06 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot07 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot07 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot08 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot08 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot09 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot09 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (ArmorSlot10 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot10 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	FoundEmptySlot = FALSE
endFunction

Function AddToWeaponSlot(Form akBaseItem)
	
	bool FoundEmptySlot = FALSE
	
	if (WeaponSlot01 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		WeaponSlot01 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (WeaponSlot02 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		WeaponSlot02 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	if (WeaponSlot03 == EmptySlot) && (FoundEmptySlot == FALSE) && NCOF.GetValueInt() == 1
		WeaponSlot03 = akBaseItem
		FoundEmptySlot = TRUE
	endif
	
	FoundEmptySlot = FALSE
endFunction


Function RemoveFromArmorSlot(Form akBaseItem)
	
	bool FoundMatchingSlot = FALSE
	
	if (ArmorSlot01 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot01 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot02 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot02 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot03 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot03 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot04 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot04 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot05 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot05 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot06 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot06 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot07 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot07 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot08 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot08 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot09 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot09 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (ArmorSlot10 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		ArmorSlot10 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
endFunction

Function RemoveFromWeaponSlot(Form akBaseItem)
	
	bool FoundMatchingSlot = FALSE
	
	if (WeaponSlot01 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		WeaponSlot01 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (WeaponSlot02 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		WeaponSlot02 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
	if (WeaponSlot03 == akBaseItem) && (FoundMatchingSlot == FALSE) && NCOF.GetValueInt() == 1
		WeaponSlot03 = EmptySlot
		FoundMatchingSlot = TRUE
	endif
	
endFunction
